<?php
/**
* Web based SQLite management
* Wrapper for Default SQLite 2.x Module
* @package SQLiteManager
* @author Tanguy Pruvot
* @version $Id: sqlite3.inc.php,v 1.2 2004/12/04 22:18:50 tpruvot Exp $ $Revision: 1.2 $
*/
define('DEBUG_QUERIES',0);
/*
try {
$PDO_DB = new PDO('sqlite:','','');
} catch (PDOException $e) { $PDO_EXCEPT=$e; }
*/

$last_result=array();

function sqlitem_array_query($dhb,$query,$result_type=SQLITE_BOTH,$decode_binary=TRUE) {
  $q = sqlitem_query($dhb,$query); 
  $rows = array();
  while ($r = sqlitem_fetch_array($q,$result_type,$decode_binary)) {
   $rows[] = $r;
  }
  return $rows;
}

function sqlitem_busy_timeout($dhb,$milliseconds=0) {
  try {
    $dhb->setAttribute(PDO_ATTR_TIMEOUT, $milliseconds);
    return true;
  } catch (PDOException $e) { return false;}
}

function sqlitem_changes($dhb) {
  return sqlite_changes($dhb);
}

function sqlitem_close($dhb) {
  $GLOBALS['PDO_DB']=false;
  return true;
}

function sqlitem_column($result,$index_or_name,$decode_binary=TRUE) {
  if (is_numeric($index_or_name)) {
    $cols = array_keys($last_result);
    return $cols[$index_or_name];
  } else
    return $last_result[$index_or_name];
}

function sqlitem_create_aggregate($dhb,$function_name,$step_func,$finalize_func,$num_args=null) {
  return sqlite_create_aggregate($dhb,$function_name,$step_func,$finalize_func,$num_args);
}

function sqlitem_create_function($dhb,$function_name,$callback,$num_arg=null) {
  return sqlite_create_function($dhb,$function_name,$callback,$num_arg);
}

function sqlitem_current($stmt,$result_type=SQLITE_BOTH,$decode_binary=TRUE) {
  $res = sqlitem_fetch_array($stmt,$result_type,$decode_binary);
//  $stmt->
  return sqlite_current($result,$result_type,$decode_binary);
}

function sqlitem_error_string($err_code) {
  if (function_exists('sqlite_error_string'))
    return sqlite_error_string($err_code);
  else 
    return 'Error '.$err_code;
}

function sqlitem_escape_string($str) {
  if (function_exists('sqlite_escape_string')) return sqlite_escape_string($str);
  $res = str_replace("'","''",$str);
  return $res;
}

function sqlitem_fetch_array($stmt,$result_type=SQLITE_BOTH,$decode_binary=TRUE) {
  $fetch_style=0;
  if (($result_type & SQLITE_NUM) == SQLITE_NUM)  $fetch_style|=PDO_FETCH_NUM;
  if (($result_type & SQLITE_BOTH) == SQLITE_BOTH)  $fetch_style|=PDO_FETCH_BOTH;
  if (($result_type & SQLITE_ASSOC) == SQLITE_ASSOC)  $fetch_style|=PDO_FETCH_ASSOC; 
  $res = $stmt->fetch($fetch_style);
  if ($stmt->errorCode() != PDO_ERR_NONE){
    $error = $stmt->errorInfo();
    print_r($error); die();
  }
  if (($result_type & SQLITE_BOTH) || ($result_type & SQLITE_ASSOC)) {
    $GLOBALS['last_result_names'] = true;
  } else {
   $GLOBALS['last_result_names'] = false;
  }
  $GLOBALS['last_result'] = $res; 
  return $res;
}

function sqlitem_fetch_single($stmt,$result_type=SQLITE_BOTH,$decode_binary=TRUE) {
/*  $fetch_style=0;
  if (($result_type & SQLITE_NUM) == SQLITE_NUM)  $fetch_style|=PDO_FETCH_NUM;
  if (($result_type & SQLITE_BOTH) == SQLITE_BOTH)  $fetch_style|=PDO_FETCH_BOTH;
  if (($result_type & SQLITE_ASSOC) == SQLITE_ASSOC)  $fetch_style|=PDO_FETCH_ASSOC; */
  $res = $stmt->fetchSingle();
  $stmt = null;
  return $res;
}

function sqlitem_fetch_string($result,$result_type=SQLITE_BOTH) {
  return sqlitem_fetch_single($result,$result_type);
}

function sqlitem_field_name($result,$index) {
die('sqlitem_field_name not implemented in PDO');
  return sqlite_field_name($result,$index);
}

function sqlitem_has_more($result) {
die('sqlitem_has_more not implemented in PDO');
  return sqlite_has_more($result);
}

function sqlitem_last_error($dbh) {
  return $dbh->errorInfo(1);
}

function sqlitem_last_insert_rowid($dbh) {
  return $dbh->lastInsertId;
}

function sqlitem_libencoding() {
die('sqlitem_libencoding not implemented in PDO');
  return sqlite_libencoding();
}

function sqlitem_libversion() {
  global $SQLiteVersion;
  return $SQLiteVersion;
}

function sqlitem_next($result) {
die('sqlitem_next');
  return sqlite_next($result);
}

function sqlitem_num_fields($result) {
  return $result->columnCount;
}

function sqlitem_num_rows($result) {
  return $result->rowCount;
}

function sqlitem_open($filename,$mode,&$error_message) { 
  global $PDO_DB;
  try {
    $user = '';
    $password = '';
    $PDO_DB = new PDO('sqlite:'.$filename, $user, $password); 
    return $PDO_DB;
  } catch (PDOException $e) {
    die($e->getMessage());
  }
}

function sqlitem_popen($filename,$mode,&$error_message) {
  return sqlitem_open($filename,$mode,$error_message);
}

function sqlitem_query($p1,$p2) {

  if (is_object($p1)) {
    $dbh=$p1;
    $query =$p2;
  } else {
    $query =$p1;
    $dbh=$p2;
  }
  //$dbh->query("INSERT INTO database VALUES (NULL, 'config', 'include/config3.db');"); die();
//  if (eregi('(SELECT |SHOW )',trim($query))) { 
    try {
      $stmt = $dbh->prepare($query);
      
      //$stmt->SetAttribute(PDO_ATTR_PREFETCH,1);
      //$stmt->SetAttribute(PDO_ATTR_CURSOR, PDO_CURSOR_SCROLL);
      
      if (!$stmt) {
        $res = $dbh->query($query);
        if ($dbh->errorCode() != PDO_ERR_NONE){
          $error = $dbh->errorInfo();
          print_r($error); die();
        }
        if (DEBUG_QUERIES) echo $query."<br/>";
        return $res;
      } else {
        $stmt->execute();
        if ($stmt->errorCode() != PDO_ERR_NONE){
          $error = $stmt->errorInfo();
          print_r($error); die();
        }
        //print_r($stmt->fetchAll()); die();
        if (DEBUG_QUERIES) echo $query." &gt;<br/>"; 
        return $stmt;
      }     
    } catch (PDOException $e) {
      $error_message = $e->getMessage();
      die($error_message);
    }
//  }
  
  return $stmt;
}

function sqlitem_rewind($result) {
die('sqlitem_rewind not implemented in PDO');
  return sqlite_rewind($result);
}

function sqlitem_seek($result,$numrow) {
die('sqlitem_seek not implemented in PDO');
  return sqlite_seek($result,$numrow);
}

function sqlitem_udf_decode_binary($data) {
die('sqlitem_udf_decode_binary not implemented in PDO');
  return sqlite_udf_decode_binary($data);
}

function sqlitem_udf_encode_binary($data) {
die('sqlitem_udf_encode_binary not implemented in PDO');
  return sqlite_udf_encode_binary($data);
}

function sqlitem_unbuffered_query($dbh,$query) {
die('sqlitem_unbuffered_query not implemented in PDO');
  return sqlite_unbuffered_query($dbh,$query);
}

?>
